function normalizeGUI()

%   This is a part of the GNAT
%   Copyright  2024  <Mathias Nilsson>%
%   This program is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   This program is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License along
%   with this program; if not, write to the Free Software Foundation, Inc.,
%   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
%
%   Dr. Mathias Nilsson
%   School of Chemistry, University of Manchester,
%   Oxford Road, Manchester M13 9PL, UK
%   Telephone: +44 (0) 161 306 4465
%   Fax: +44 (0)161 275 4598
%
%   Hugo da Silva Rocha, Undergrad Studant
%   Institute of Chemistry, Univeristy of Brasilia,
%   POBOX 70910-900, Asa Norte - Brasília (DF), Brazil
%   rocha.hugo@aluno.unb.br

%% Setup the GUI CONTROLS
NormGNAT.title='Normalize';
NormFig = figure(...
    'Units','normalized',...
    'Name',NormGNAT.title,...     
    'MenuBar','none',...
    'NumberTitle','Off',...
    'OuterPosition',[0.0 0.0 0.2 0.30],... 
    'Tag','NormGUI',...
    'Color','w',...
    'Visible','off');
NormGNAT.ForceCloseFlag = 1;
NormGNAT.NormFig = NormFig;
movegui(NormFig,'center')
guidata(NormFig,NormGNAT);

%% Setup the Norm Painel
hNormProcessPanel=uipanel(...
    'Parent',NormFig,...
    'TitlePosition','centertop',...
    'Units','Normalized',...
    'FontWeight','bold',...
    'BackgroundColor','w',...
    'Position',[0.016 0.01 0.98 0.98]);
%% Method Selection
hData_selection=uipanel(...
    'Parent',hNormProcessPanel,...
    'TitlePosition','centertop',...
    'Units','Normalized',...
    'FontWeight','bold',...
    'BackgroundColor','w',...
    'Position',[0.01 0.58 0.98 0.40]);

%hTextStart=
uicontrol(...
    'Parent',hData_selection,...
    'Style','text',...
    'Units','Normalized',...
    'Position',[0.05 0.54 0.45 0.3 ],...
    'horizontalalignment','left',...
    'BackgroundColor','w',...
    'String','Normalize method:');
hNormSchem = uicontrol(...
    'Parent',hData_selection,...
    'Style','popupmenu',...
    'Units','Normalized',...
    'value',1,...
    'TooltipString','Integral method for each bin',...
    'FontWeight','normal',...
    'FontSize',8.5,...
    'HorizontalAlignment','center',...
    'BackgroundColor','w',...    
    'String','Total Area|Largest Peak|PQN|Quantile|Intensity Reference|Integral Range|None',...
    'Position',[0.54,0.60,0.43,0.28]);

%hTextStart=
uicontrol(...
    'Parent',hData_selection,...
    'Style','text',...
    'Units','Normalized',...
    'Position',[0.05 0.13 0.45 0.3 ],...
    'horizontalalignment','left',...
    'BackgroundColor','w',...
    'String','Value:' );
hNormValue=uicontrol(...
    'Parent',hData_selection,...
    'Style','edit',...
    'BackgroundColor','w',...
    'String',100,...
    'Units','Normalized',...
    'Position',[0.54 0.15 0.43 0.27]); 

%% Range Selection
hRange_selection=uipanel(...
    'Parent',hNormProcessPanel,...
    'TitlePosition','centertop',...
    'Units','Normalized',...
    'FontWeight','bold',...
    'BackgroundColor','w',...
    'Title','Range',...
    'Position',[0.01 0.21 0.63 0.37]);

%hTextStart=
uicontrol(...
    'Parent',hRange_selection,...
    'Style','text',...
    'Units','Normalized',...
    'Position',[0.03 0.20 0.25 0.47 ],...
    'horizontalalignment','left',...
    'BackgroundColor','w',...
    'String','Left:' );
hLeftRange=uicontrol(...
    'Parent',hRange_selection,...
    'Style','edit',...
    'BackgroundColor','w',...
    'String',10,...
    'Units','Normalized',...
    'Position',[0.22 0.25 0.20 0.60]);
%hTextStart=
uicontrol(...
    'Parent',hRange_selection,...
    'Style','text',...
    'Units','Normalized',...
    'Position',[0.48 0.20 0.25 0.47 ],...
    'horizontalalignment','left',...
    'BackgroundColor','w',...
    'String','Right:' );
hRightRange=uicontrol(...
    'Parent',hRange_selection,...
    'Style','edit',...
    'BackgroundColor','w',...
    'String',10,...
    'Units','Normalized',...
    'Position',[0.72 0.25 0.20 0.60]); 

%% Corfimation buttons
hOKButton = uicontrol(...
    'Parent',hNormProcessPanel,...
    'Style','PushButton',...
    'String','OK',...
    'Units','normalized',...
    'Position',[0.65 0.40 0.34 0.16],...
    'Callback', {@CalculationNorm});
hClearButton = uicontrol(...
    'Parent',hNormProcessPanel,...
    'Style','PushButton',...
    'String','Clear',...
    'Units','normalized',...
    'Position',[0.65 0.21 0.34 0.16],...
    'Callback', {@CalculationNorm});

%% Tips for user
hTips=uipanel(...
    'Parent',hNormProcessPanel,...
    'Title','Tips',...
    'TitlePosition','centertop',...
    'Units','Normalized',...
    'FontWeight','bold',...
    'Position',[0.01 0.0002 0.98 0.19]);
%hTextStart=
uicontrol(...
    'Parent',hTips,...
    'Style','text',...
    'Units','Normalized',...
    'Position',[0.03 0.05 0.95 0.95],...
    'horizontalalignment','left',...
    'String','For PLS-DA and OPLS-DA, the ideal order of preprocessing is Binning->Normalization->Cal/Val Run->Process Run.' ); 

%% Setup GUI
SetUpGUINorm_Callback()

%% Main Callbacks
    function SetUpGUINorm_Callback(source,eventdata)
        NormGNAT = guidata(NormFig);

        % Resizing all components of the GUI for all types of monitors
        txtHand = findall(NormFig, '-property', 'FontUnits'); 
        set(txtHand, 'FontUnits', 'normalized')
        set(NormFig,'Visible','on')

        % importing info from GNAT
        hMainFigure = findobj('Type','figure','Tag','MainFigure');
        if ~isempty(hMainFigure)
            NmrData = guidata(hMainFigure(1));
        else
            return
        end

        % Checking the active area of the spectrum
        hAxes = findall(hMainFigure, 'type', 'axes');
        speclim=xlim(hAxes);
        if iscell(speclim)
            speclim=cell2mat(speclim);
        end

        if speclim(1)<NmrData.sp
            speclim(1)=NmrData.sp;
        end
        if speclim(2)>(NmrData.sw+NmrData.sp)
            speclim(2)=(NmrData.sw+NmrData.sp);
        end  
        for p=1:length(NmrData.Specscale  )
            if (NmrData.Specscale  (p)>speclim(1))
               begin=p-1;
               k1=begin;
               break;
            end
        end        
        for p=begin:length(NmrData.Specscale  )
           if (NmrData.Specscale  (p)>=speclim(2))
               endrange=p;
               break;
           end
        end 

        % Setting parameters in the GUI
        Rgt=round(NmrData.Specscale(k1),2);
        Lf=round(NmrData.Specscale(endrange),2);

        NormGNAT.features = [Lf,Rgt];
        NormGNAT.matrix = NmrData.Normalised.GNAT_matrix;
        NormGNAT.rawmatrix = NmrData.Normalised.GNAT_raw_matrix;
        NormGNAT.ppm = NmrData.Specscale;

        set(hLeftRange,'string',num2str(Lf))
        set(hRightRange,'string',num2str(Rgt))

        set(hLeftRange,'string',num2str(6.1))
        set(hRightRange,'string',num2str(5.9))
        guidata(NormFig,NormGNAT);
    end

    function CalculationNorm(source,eventdata)
        NormGNAT = guidata(NormFig);

        % importing info from GNAT
        hMainFigure = findobj('Type','figure','Tag','MainFigure');
        if ~isempty(hMainFigure)
            NmrData = guidata(hMainFigure(1));
        else
            return
        end

        if strcmp(source.String,'Clear')
            if isfield(NmrData,'Normalised')
                NmrData = rmfield(NmrData, 'Normalised');
                guidata(hMainFigure(1),NmrData);
            end
        else
            item1 = get(hNormSchem,'Value'); % list entry
            NormGNAT.value = str2num(get(hNormValue,'String'));
    
            Lf=str2num(get(hLeftRange,'String'));
            Rgt=str2num(get(hRightRange,'String'));
    
            % Lf = 5.93;
            % Rgt = 5.91;
    
            NormGNAT.features = [Lf,Rgt];
    
            switch item1
	            case 1
		            NormGNAT.method = 'total';
	            case 2
                    NormGNAT.method = 'largest';
                case 3
                    NormGNAT.method = 'pqn';
                case 4
                    NormGNAT.method = 'quantile';
                case 5
                    NormGNAT.method = 'intensity';
                case 6
                    NormGNAT.method = 'integral';
                case 7
                    NormGNAT.method = 'none';
            end
    
            if ~isempty(NmrData.reference)
                peakPPM=(NmrData.reference-NmrData.sp)/NmrData.sw;
                peakID=round(peakPPM*NmrData.fn);
                [XN,factors]=NormaliseGNAT2(NormGNAT.matrix',NormGNAT.ppm,NormGNAT.method,NormGNAT.features,NormGNAT.value,peakID,NormGNAT.rawmatrix');
            else
                [XN,factors]=NormaliseGNAT2(NormGNAT.matrix',NormGNAT.ppm,NormGNAT.method,NormGNAT.features,NormGNAT.value);
            end        
    
            NmrData.Normalised.matrix = XN;
            NmrData.Normalised.factor = factors;
            NmrData.Normalised.method = NormGNAT.method;
            guidata(hMainFigure(1),NmrData);
        end

        guidata(NormFig,NormGNAT);
    end
end